####################################################
### code chunk number : Simulations: 
### two inequalities
### delta_s, delta_2, PESL_s, PESL_2 
### three methods: oracle, moment, mle
### fix n and m
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
set.seed(1)
alpha = 2            ## hyperparameter
beta = 2             ## hyperparameter
v = 5                ## hyperparameter
n = 1e4              ## sample size

## generate the sample
theta = 1 / rgamma(n = n + 1, shape = alpha, scale = beta)
x = 1 / rgamma(n = n + 1, shape = v, scale = theta) 

## 
## oracle estimators
## 
## Compute_Estimators_PESLs_new
res_oracle = Compute_Estimators_PESLs_new(x_np1 = x[n + 1], alpha = alpha, beta = beta, v = v)
res_oracle

## 
## Moment estimators
## 
alpha_1_beta_1_v_1 = Moment_estimators_EX_EX2_EX3_new(x = x[1:n]); alpha_1_beta_1_v_1
alpha_1 = alpha_1_beta_1_v_1[1]; alpha_1
beta_1 = alpha_1_beta_1_v_1[2]; beta_1
v_1 = alpha_1_beta_1_v_1[3]; v_1

## Compute_Estimators_PESLs_new
res_moment = Compute_Estimators_PESLs_new(x_np1 = x[n + 1], alpha = alpha_1, beta = beta_1, v = v_1)
res_moment
res_moment - res_oracle


## 
## MLEs
## 
## The MLEs are very sensitive to the initial guesses. 
## The moment estimators are usually good initial guesses.
## 
alpha_2_beta_2_v_2 = Newtons(fun = moment_fun, y = alpha_1_beta_1_v_1)$root; alpha_2_beta_2_v_2
alpha_2 = alpha_2_beta_2_v_2[1]; alpha_2
beta_2 = alpha_2_beta_2_v_2[2]; beta_2
v_2 = alpha_2_beta_2_v_2[3]; v_2

## Compute_Estimators_PESLs_new
res_MLE = Compute_Estimators_PESLs_new(x_np1 = x[n + 1], alpha = alpha_2, beta = beta_2, v = v_2)
res_MLE
res_MLE - res_oracle


####################################################
### code chunk number : Simulations: 
### two inequalities
### delta_s, delta_2, PESL_s, PESL_2 
### three methods: oracle, moment, mle
### fix n, m = 1, 2, ..., M = 100
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

ptm = proc.time()
## initialization
set.seed(1)
alpha = 2            ## hyperparameter
beta = 2             ## hyperparameter
v = 5                ## hyperparameter
n = 1e4              ## sample size
M0 = 100; M0         ## number of required simulations
M1 = 120; M1         ## number of maximum tried simulations
## M2: number of actually tried simulations
## M:  number of effective simulations, finally M = M0

Matrix_M1_4 = matrix(0, nrow = M1, ncol = 4)
colnames(Matrix_M1_4) = c("delta_s", "delta_2", "PESL_s", "PESL_2")
res_oracle = res_moment = res_MLE = as.data.frame(Matrix_M1_4)
Index = numeric(M1)
names(Index) = 1:M1
Index_MLE_warning_error = Index
M = 0
for (m in 1:M1){
	cat("\n"); print(paste("In this cycle, m = ", m, sep = "")); cat("\n")
	M = M + 1
	set.seed(m)
	## generate the sample
	theta_m = 1 / rgamma(n = n + 1, shape = alpha, scale = beta)
	x_m = 1 / rgamma(n = n + 1, shape = v, scale = theta_m) 

	## 
	## oracle estimators
	## 
	## Compute_Estimators_PESLs_new
	res_oracle[m, ] = Compute_Estimators_PESLs_new(x_np1 = x_m[n + 1], alpha = alpha, beta = beta, v = v)
	
	## 
	## Moment estimators
	## 
	alpha_1_beta_1_v_1_m = Moment_estimators_EX_EX2_EX3_new(x = x_m[1:n]); alpha_1_beta_1_v_1_m
	alpha_1_m = alpha_1_beta_1_v_1_m[1]; alpha_1_m
	beta_1_m = alpha_1_beta_1_v_1_m[2]; beta_1_m
	v_1_m = alpha_1_beta_1_v_1_m[3]; v_1_m

	## Compute_Estimators_PESLs_new
	res_moment[m, ] = Compute_Estimators_PESLs_new(x_np1 = x_m[n + 1], alpha = alpha_1_m, beta = beta_1_m, v = v_1_m)


	## 
	## MLEs
	## 
	## The MLEs are very sensitive to the initial guesses. 
	## The moment estimators are usually good initial guesses.
	## 
	x = x_m[1:n] ## note here!
	alpha_2_beta_2_v_2_m = tryCatch ( {
		Newtons(fun = moment_fun, y = alpha_1_beta_1_v_1_m)$root
	} , warning = function ( w ) {
		alpha_1_beta_1_v_1_m
	} , error = function ( e ) {
		alpha_1_beta_1_v_1_m
	} , finally = {
		""
	}
	)
	
	if (all(alpha_2_beta_2_v_2_m == alpha_1_beta_1_v_1_m)){
		cat("\n alpha_2_beta_2_v_2_m = alpha_1_beta_1_v_1_m\n")
		Index_MLE_warning_error[m] = 1
	}
	
	alpha_2_m = alpha_2_beta_2_v_2_m[1]; alpha_2_m
	beta_2_m = alpha_2_beta_2_v_2_m[2]; beta_2_m
	v_2_m = alpha_2_beta_2_v_2_m[3]; v_2_m

	## Compute_Estimators_PESLs_new
	res_MLE[m, ] = Compute_Estimators_PESLs_new(x_np1 = x_m[n + 1], alpha = alpha_2_m, beta = beta_2_m, v = v_2_m)
	
	if (M == M0){
		M2 = m
		cat("\n"); print(paste("M == M0, M2 = ", m, sep = "")); cat("\n")
		break
	}
}
Index_MLE_warning_error
sum(Index_MLE_warning_error)
res_oracle
res_moment
res_MLE
Time_compute = (proc.time() - ptm)[3]; Time_compute

res_oracle = res_oracle[1:M0, ]
res_moment = res_moment[1:M0, ]
res_MLE = res_MLE[1:M0, ]

##
## plot delta_s, delta_2, PESL_s, PESL_2
##
MM = 1:M0

## plot delta_s
dev.new()
col = c("red", "purple", "blue")
lty = 1:3
xlim = range(MM); xlim
ylim = range(res_oracle[, 1], res_MLE[, 1], res_moment[, 1]); ylim
plot(MM,  res_oracle[, 1], type = "n", xlim = xlim, ylim = ylim, xlab = expression(m), ylab = "delta_s", sub = "(a)")
lines(MM, res_oracle[, 1],  lty = lty[1], col = col[1], lwd = 4)
lines(MM, res_MLE[, 1],     lty = lty[2], col = col[2], lwd = 4)
lines(MM, res_moment[, 1],  lty = lty[3], col = col[3], lwd = 4)
# title(Title)
leg.txt = c("oracle", "mle", "moment")
legend("topleft", legend = leg.txt, lty = lty, col = col, lwd = 2)
savePlot(filename = paste("figure/delta_s_vs_m", sep=""), type = c("pdf"))
savePlot(filename = paste("figure/delta_s_vs_m", sep=""), type = c("jpg"))

## plot delta_2
dev.new()
col = c("red", "purple", "blue")
lty = 1:3
xlim = range(MM); xlim
ylim = range(res_oracle[, 2], res_MLE[, 2], res_moment[, 2]); ylim
plot(MM,  res_oracle[, 2], type = "n", xlim = xlim, ylim = ylim, xlab = expression(m), ylab = "delta_2", sub = "(b)")
lines(MM, res_oracle[, 2],  lty = lty[1], col = col[1], lwd = 4)
lines(MM, res_MLE[, 2],     lty = lty[2], col = col[2], lwd = 4)
lines(MM, res_moment[, 2],  lty = lty[3], col = col[3], lwd = 4)
# title(Title)
leg.txt = c("oracle", "mle", "moment")
legend("topleft", legend = leg.txt, lty = lty, col = col, lwd = 2)
savePlot(filename = paste("figure/delta_2_vs_m", sep=""), type = c("pdf"))
savePlot(filename = paste("figure/delta_2_vs_m", sep=""), type = c("jpg"))

## plot PESL_s
dev.new()
col = c("red", "purple", "blue")
lty = 1:3
xlim = range(MM); xlim
ylim = c(0.05, max(res_oracle[, 3], res_MLE[, 3], res_moment[, 3])); ylim
# ylim = range(res_oracle[, 3], res_MLE[, 3], res_moment[, 3]); ylim
plot(MM,  res_oracle[, 3], type = "n", xlim = xlim, ylim = ylim, xlab = expression(m), ylab = "PESL_s", sub = "(c)")
lines(MM, res_oracle[, 3],  lty = lty[1], col = col[1], lwd = 4)
lines(MM, res_MLE[, 3],     lty = lty[2], col = col[2], lwd = 4)
lines(MM, res_moment[, 3],  lty = lty[3], col = col[3], lwd = 4)
# title(Title)
leg.txt = c("oracle", "mle", "moment")
legend("bottomleft", legend = leg.txt, lty = lty, col = col, lwd = 2)
savePlot(filename = paste("figure/PESL_s_vs_m", sep=""), type = c("pdf"))
savePlot(filename = paste("figure/PESL_s_vs_m", sep=""), type = c("jpg"))

## plot PESL_2
dev.new()
col = c("red", "purple", "blue")
lty = 1:3
xlim = range(MM); xlim
ylim = c(0.05, max(res_oracle[, 4], res_MLE[, 4], res_moment[, 4])); ylim
# ylim = range(res_oracle[, 4], res_MLE[, 4], res_moment[, 4]); ylim
plot(MM,  res_oracle[, 4], type = "n", xlim = xlim, ylim = ylim, xlab = expression(m), ylab = "PESL_2", sub = "(d)")
lines(MM, res_oracle[, 4],  lty = lty[1], col = col[1], lwd = 4)
lines(MM, res_MLE[, 4],     lty = lty[2], col = col[2], lwd = 4)
lines(MM, res_moment[, 4],  lty = lty[3], col = col[3], lwd = 4)
# title(Title)
leg.txt = c("oracle", "mle", "moment")
legend("bottomleft", legend = leg.txt, lty = lty, col = col, lwd = 2)
savePlot(filename = paste("figure/PESL_2_vs_m", sep=""), type = c("pdf"))
savePlot(filename = paste("figure/PESL_2_vs_m", sep=""), type = c("jpg"))


##
## moment vs MLE
##
abs_error_moment = abs(res_moment - res_oracle); abs_error_moment
abs_error_MLE = abs(res_MLE - res_oracle); abs_error_MLE

## boxplots
dev.new()
boxplot(abs_error_moment[, 1], abs_error_MLE[, 1], names = c("moment", "mle"), col = c("red", "blue"), ylab = "delta_s", sub = "(a)")
savePlot(filename = paste("figure/boxplots_delta_s", sep=""), type = c("pdf"))

dev.new()
boxplot(abs_error_moment[, 2], abs_error_MLE[, 2], names = c("moment", "mle"), col = c("red", "blue"), ylab = "delta_2", sub = "(b)")
savePlot(filename = paste("figure/boxplots_delta_2", sep=""), type = c("pdf"))

dev.new()
boxplot(abs_error_moment[, 3], abs_error_MLE[, 3], names = c("moment", "mle"), col = c("red", "blue"), ylab = "PESL_s", sub = "(c)")
savePlot(filename = paste("figure/boxplots_PESL_s", sep=""), type = c("pdf"))

dev.new()
boxplot(abs_error_moment[, 4], abs_error_MLE[, 4], names = c("moment", "mle"), col = c("red", "blue"), ylab = "PESL_2", sub = "(d)")
savePlot(filename = paste("figure/boxplots_PESL_2", sep=""), type = c("pdf"))

## compute averages
averages_abs_error_moment = colMeans(abs_error_moment); averages_abs_error_moment
averages_abs_error_MLE = colMeans(abs_error_MLE); averages_abs_error_MLE

## compute proportions
source("subfunctions.R")
Averages_Proportions = matrix(0, nrow = 4, ncol = 4)
colnames(Averages_Proportions) = c("Averages_moment", "Averages_mle", "Proportions_moment", "Proportions_mle")
rownames(Averages_Proportions) = c("delta_s", "delta_2", "PESL_s", "PESL_2")
Averages_Proportions[, 1] = averages_abs_error_moment
Averages_Proportions[, 2] = averages_abs_error_MLE
Averages_Proportions[1, 3:4] = Compute_Proportions_2vectors_pmin(v1 = abs_error_moment[, 1], v2 = abs_error_MLE[, 1])
Averages_Proportions[2, 3:4] = Compute_Proportions_2vectors_pmin(v1 = abs_error_moment[, 2], v2 = abs_error_MLE[, 2])
Averages_Proportions[3, 3:4] = Compute_Proportions_2vectors_pmin(v1 = abs_error_moment[, 3], v2 = abs_error_MLE[, 3])
Averages_Proportions[4, 3:4] = Compute_Proportions_2vectors_pmin(v1 = abs_error_moment[, 4], v2 = abs_error_MLE[, 4])
round(Averages_Proportions, 2)

Averages = Averages_Proportions[, 1:2]; round(Averages, 4)
Proportions = Averages_Proportions[, 3:4]; round(Proportions, 2)
A = cbind(format(round(Averages, 4), nsmall = 4), format(round(Proportions, 2), nsmall = 2)); A
Generate_Matrix_Latex(A)
# A = cbind(round(Averages, 4), round(Proportions, 2)); A
# Generate_Matrix_Latex(A)



